package Modul9.Video3;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

/**
 * (c) programmierenlernen.info
 * Java Grundkurs
 * --
 * Jan Brinkmann
 */
public class FensterAuf extends JFrame implements ActionListener, WindowListener
{
    JTextField counter;
    JButton plus;
    JButton minus;
    int currentCount = 0;

    public FensterAuf(String fensterTitel)
    {
        super(fensterTitel);
        addWindowListener(this);

        JPanel mainPanel = new JPanel(new BorderLayout());

        JPanel counterPanel = new JPanel();
        JLabel zaehlerLabel = new JLabel("Zähler: ");
        counterPanel.add(zaehlerLabel);

        counter = new JTextField(3);
        counterPanel.add(counter);

        mainPanel.add(counterPanel, BorderLayout.NORTH);

        JPanel buttonPanel = new JPanel();
        plus = new JButton("+");
        plus.addActionListener(this);
        buttonPanel.add(plus);

        minus = new JButton("-");
        minus.addActionListener(this);
        buttonPanel.add(minus);

        mainPanel.add(buttonPanel, BorderLayout.CENTER);

        setContentPane(mainPanel);
    }

    public static void main(String[] args)
    {
        FensterAuf meinFrame = new FensterAuf("Hallo grafische Welt");
        meinFrame.setSize(400, 300);
        meinFrame.setVisible(true);
    }

    public void actionPerformed(ActionEvent e)
    {
        if (e.getActionCommand() == "+") {
            currentCount++;
        } else if (e.getActionCommand() == "-") {
            if (currentCount > 0) {
                currentCount--;
            }
        }
        counter.setText(new Integer(currentCount).toString());
    }

    public void windowClosing(WindowEvent e)
    {
        dispose();
        System.exit(0);
    }

    public void windowOpened(WindowEvent e) {}
    public void windowActivated(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowDeactivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}

}
