package Uebungsaufgaben.Modul9;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

/**
 * (c) programmierenlernen.info
 * Java Grundkurs
 * --
 * Jan Brinkmann
 */
public class LbsKgConvert extends JFrame implements WindowListener,ActionListener
{
    private JTextField kgInput;
    private JTextField lbsInput;

    public LbsKgConvert(String windowTitle)
    {
        super(windowTitle);
        addWindowListener(this);

        // mainPanel
        JPanel mainPanel = new JPanel(new GridLayout(3,1));

        // Kg Panel
        JPanel kgPanel = new JPanel();

        JLabel kgLabel = new JLabel("Kg:");
        kgPanel.add(kgLabel);

        kgInput = new JTextField(20);
        kgPanel.add(kgInput);

        mainPanel.add(kgPanel);

        // Lbs Panel
        JPanel lbsPanel = new JPanel();

        JLabel lbsLabel = new JLabel("Lbs:");
        lbsPanel.add(lbsLabel);

        lbsInput = new JTextField(20);
        lbsPanel.add(lbsInput);

        mainPanel.add(lbsPanel);

        // button
        JPanel buttonPanel = new JPanel();

        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(this);
        buttonPanel.add(resetButton);

        JButton convertButton = new JButton("Umwandeln");
        convertButton.addActionListener(this);
        buttonPanel.add(convertButton);

        mainPanel.add(buttonPanel);

        this.setContentPane(mainPanel);
    }

    public static void main(String[] args)
    {
        LbsKgConvert converter = new LbsKgConvert("Convert Lbs<->Kg");
        converter.setSize(350,140);
        converter.setVisible(true);
    }

    public void actionPerformed(ActionEvent e)
    {
        if (e.getActionCommand().equals("Reset")) {
            lbsInput.setText("");
            kgInput.setText("");
        } else if (e.getActionCommand().equals("Umwandeln")) {
            this.startConversion();
        }
    }

    private void startConversion()
    {
        String kgValue = kgInput.getText();
        String lbsValue = lbsInput.getText();

        if (!kgValue.isEmpty()) {
            String newLbsValue = this.convertKgToLbs(kgValue);
            lbsInput.setText(newLbsValue);
        } else if (!lbsValue.isEmpty()) {
            String newKgValue = this.convertLbsToKg(lbsValue);
            kgInput.setText(newKgValue);
        }
    }

    private String convertKgToLbs(String kgValue)
    {
        Double oldValue = new Double(kgValue);
        Double newValue = new Double(oldValue.doubleValue() * 2.2046226218487757);

        return newValue.toString();
    }

    private String convertLbsToKg(String lbsValue)
    {
        Double oldValue = new Double(lbsValue);
        Double newValue = new Double(oldValue.doubleValue() * 0.45359237);

        return newValue.toString();
    }

    public void windowClosing(WindowEvent e)
    {
        dispose();
        System.exit(0);
    }
    public void windowOpened(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowActivated(WindowEvent e) {}
    public void windowDeactivated(WindowEvent e) {}
}
