package Abschlussprojekt;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.security.InvalidParameterException;

/**
 * Grundlegender Taschenrechner
 *
 * @author Jan Brinkmann
 */
public class Taschenrechner extends JFrame implements ActionListener, WindowListener
{
    private JTextField inputField;

    // Register für die Werte
    private String operand = "";
    private double currentValue = 0;

    /**
     * Konstruktur zur Initialisierung
     *
     * @param windowTitle Ein Fenster Titel
     */
    public Taschenrechner(String windowTitle)
    {
        super(windowTitle);
        addWindowListener(this);
        this.setContentPane(this.getCalculatorPanel());
    }

    /**
     * Einstiegspunkt für Java
     *
     * @param args Die Kommandozeilenparameter
     */
    public static void main(String[] args)
    {
        Taschenrechner calcWindow = new Taschenrechner("Calculator");
        calcWindow.setSize(325, 200);
        calcWindow.setResizable(false);
        calcWindow.setVisible(true);
    }

    /**
     * ActionListener für die Buttons
     * @param e Das ActionEvent
     */
    public void actionPerformed(ActionEvent e)
    {
        String buttonPressed = e.getActionCommand();

        switch (buttonPressed.charAt(0)) {
            case 'C':
                this.clearState();
                break;

            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
            case '0':
            case '.':
                if (inputField.getText().equals("0")) {
                    inputField.setText("");
                }

                inputField.setText(inputField.getText() + buttonPressed);
                break;

            case '+':
            case '-':
            case '/':
            case 'x':
                this.calculate(buttonPressed);
                inputField.setText("");
                break;

            case '=':
                this.calculate(this.operand);
                inputField.setText(Double.toString(currentValue));
                this.currentValue = 0.0;
        }
    }

    /**
     * Zurücksetzen des Rechners auf 0
     */
    private void clearState()
    {
        this.currentValue = 0.0;
        this.inputField.setText("");
    }

    /**
     * Verarbeitet die Eingaben
     *
     * @param operand Welche Operation wurde geklickt?
     */
    public void calculate(String operand)
    {
        this.operand = operand;
        double currentInput = Double.parseDouble(inputField.getText());

        // initiale eingabe
        if (currentValue == 0) {
            currentValue = currentInput;
            return;
        }

        if (operand.equals("+")) {
            currentValue = this.addieren(currentValue, currentInput);
        } else if (operand.equals("-")) {
            currentValue = this.subtrahieren(currentValue, currentInput);
        } else if (operand.equals("x")) {
            currentValue = this.multiplizieren(currentValue, currentInput);
        } else if (operand.equals("/")) {
            currentValue = this.dividieren(currentValue, currentInput);
        }
    }

    /**
     * Methode zum Addieren
     *
     * @param a Zahl a
     * @param b Zahl b
     * @return Summe ist gleich a plus b
     */
    public double addieren(double a, double b)
    {
        return a + b;
    }

    /**
     * Methode zum Subtrahieren
     *
     * @param a Zahl a
     * @param b Zahl b
     * @return Differenz ist gleich a minus b
     */
    public double subtrahieren(double a, double b)
    {
        return a - b;
    }

    /**
     * Methode zum Multiplizieren
     *
     * @param a Zahl a
     * @param b Zahl b
     * @return Produkt ist gleich a und b
     */
    public double multiplizieren(double a, double b)
    {
        return a*b;
    }

    /**
     * Methode zum Dividieren
     *
     * @param a Zahl a
     * @param b Zahl b
     * @return Quotient ist gleich a geteilt durch b
     */
    public double dividieren(double a, double b)
    {
        return a/b;
    }

    /**
     * Hilfsmethode, die das Hauptpanel zusammenbaut
     *
     * @return JPanel Das fertige Hauptpanel
     */
    public JPanel getCalculatorPanel()
    {
        JPanel calcPanel = new JPanel( new GridLayout(5, 1) );

        // inputPanel
        calcPanel.add(this.getInputPanel());

        // Zeile1 (1,2,3,-)
        String[] buttonsOne = {"1", "2", "3", "-"};
        calcPanel.add(this.getRowPanel(buttonsOne, this));

        // Zeile2 (4,5,6,+)
        String[] buttonsTwo = {"4", "5", "6", "+"};
        calcPanel.add(this.getRowPanel(buttonsTwo, this));

        // Zeile3 (7,8,9,x)
        String[] buttonsThree = {"7", "8", "9", "x"};
        calcPanel.add(this.getRowPanel(buttonsThree, this));

        // Zeile4 (0,.,=,/)
        String[] buttonsFour = {"0", ".", "=", "/"};
        calcPanel.add(this.getRowPanel(buttonsFour, this));

        return calcPanel;
    }

    /**
     * Erzeugt die einzelnen Zeilen mit Buttons
     *
     * @param buttonTexts String[] Array
     * @param actionListener
     * @return JPanel mit Buttons
     * @throws InvalidParameterException
     */
    private JPanel getRowPanel(String[] buttonTexts, ActionListener actionListener)
            throws InvalidParameterException
    {
        // erzeuge Panel
        JPanel tmpPanel = new JPanel();
        for (short i = 0; i < buttonTexts.length; i++) {
            JButton aButton = new JButton(buttonTexts[i]);
            aButton.addActionListener(actionListener);
            tmpPanel.add(aButton);
        }

        return tmpPanel;
    }

    /**
     * Erzeugt das Panel mit Eingabefeld und Clear-Button
     *
     * @return JPanel Das fertige InputPanel
     */
    private JPanel getInputPanel()
    {
        JPanel tmpPanel = new JPanel();

        // input
        inputField = new JTextField(18);
        inputField.setText("0");
        inputField.setEditable(false);
        tmpPanel.add(inputField);

        // clear button
        JButton clearButton = new JButton("C");
        clearButton.addActionListener(this);
        tmpPanel.add(clearButton);

        return tmpPanel;
    }

    /**
     * Der WindowListener
     * @param e Das WindowEvent
     */
    public void windowClosing(WindowEvent e) {
        dispose();
        System.exit(0);
    }

    public void windowOpened(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowActivated(WindowEvent e) {}
    public void windowDeactivated(WindowEvent e) {}
}
