package Modul9.Video5;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

/**
 * (c) programmierenlernen.info
 * Java Grundkurs
 * --
 * Jan Brinkmann
 */
public class FensterAuf extends JFrame implements ActionListener, WindowListener
{
    private DefaultListModel namensListeModel;
    private JTextField inputField;

    public FensterAuf(String fensterTitel)
    {
        super(fensterTitel);
        addWindowListener(this);

        JPanel mainPanel = new JPanel(new GridLayout(2, 1));

        // zeile1 im grid
        namensListeModel = new DefaultListModel();
        JList namensListe = new JList(namensListeModel);
        mainPanel.add(namensListe);

        // zeile2 im grid
        JPanel addPanel = new JPanel();

        inputField = new JTextField(15);
        addPanel.add(inputField);

        JButton okButton = new JButton("+");
        okButton.addActionListener(this);
        addPanel.add(okButton);

        JButton helpButton = new JButton("?");
        helpButton.addActionListener(this);
        addPanel.add(helpButton);

        mainPanel.add(addPanel);
        setContentPane(mainPanel);
    }

    public static void main(String[] args)
    {
        FensterAuf meinFrame = new FensterAuf("Hallo grafische Welt");
        meinFrame.setSize(400, 300);
        meinFrame.setVisible(true);
    }

    public void actionPerformed(ActionEvent e)
    {
        if (e.getActionCommand() == "+") {
            String newValue = inputField.getText();
            namensListeModel.addElement(newValue);
            inputField.setText("");

        } else if (e.getActionCommand() == "?") {
            showHelpDialog();
        }

    }

    private void showHelpDialog()
    {
        JDialog helpDialog = new JDialog(this);
        helpDialog.add(new JLabel("Mit '+' Werte zur Liste hinzufügen"));
        helpDialog.setModal(true);
        helpDialog.setSize(200,100);
        helpDialog.setVisible(true);
    }

    public void windowClosing(WindowEvent e)
    {
        dispose();
        System.exit(0);
    }

    public void windowOpened(WindowEvent e) {}
    public void windowActivated(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowDeactivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}

}
